import viz
viz.go()

NUM_BOXES = 10

import viznet

#Generate network event IDs
CLIENT_MOUSE_MOVE	= viznet.id('ClientMouseMove')
CLIENT_MOUSE_DOWN	= viznet.id('ClientMouseDown')
CLIENT_MOUSE_UP		= viznet.id('ClientMouseUp')
CLIENT_ADD_GRABBER	= viznet.id('ClientAddGrabber')
CLIENT_DEL_GRABBER	= viznet.id('ClientDelGrabber')
CLIENT_UPDATE		= viznet.id('ClientUpdate')

#Connect to server
viznet.client.connect('Renderer')

#Initialize view/window settings
viz.MainView.setPosition(0,7,-20)
viz.MainView.lookat(0,0,0)
viz.MainWindow.clearcolor(viz.SKYBLUE)
viz.MainWindow.mouse(0)

#Don't allow clients to resize window
viz.window.setBorder(viz.BORDER_FIXED)
def onKeyDown(key):
	return key == viz.KEY_F2
viz.callback(viz.KEYDOWN_EVENT,onKeyDown,priority=viz.PRIORITY_DEFAULT_KEY-1)

#Create ground plane
ground = viz.add('tut_ground.wrl')

#Add a bunch of boxes to the physics simulation
boxes = []
for x in range(NUM_BOXES):
	box = viz.add('box.wrl')
	boxes.append(box)

def SendData():
	"""Send mouse position"""
	pos = viz.mouse.getPosition(viz.WINDOW_PIXELS)
	line = viz.screentoworld(viz.mouse.getPosition())
	viznet.client.send(CLIENT_MOUSE_MOVE,pos = pos,line=line)
vizact.ontimer(0,SendData)

def SendMouseDown():
	"""Send mouse down event"""
	line = viz.screentoworld(viz.mouse.getPosition())
	viznet.client.send(CLIENT_MOUSE_DOWN,line=line)
vizact.onmousedown(viz.MOUSEBUTTON_LEFT,SendMouseDown)

def SendMouseUp():
	"""Send mouse up event"""
	viznet.client.send(CLIENT_MOUSE_UP)
vizact.onmouseup(viz.MOUSEBUTTON_LEFT,SendMouseUp)


import Grabber

def onAddGrabber(e):
	"""Add a new grabber"""
	Grabber.addGrabber(e.name)
viz.callback(CLIENT_ADD_GRABBER,onAddGrabber)

def onDelGrabber(e):
	"""Remove a grabber"""
	Grabber.removeGrabber(e.name)
viz.callback(CLIENT_DEL_GRABBER,onDelGrabber)

def onUpdateGrabbers(e):
	"""Update grabbers"""
	for i in xrange(NUM_BOXES):
		boxes[i].setPosition(e.boxdata[i][0])
		boxes[i].setQuat(e.boxdata[i][1])
	for n,d in e.grabdata.iteritems():
		g = Grabber.getGrabber(n)
		if g:
			g.update(*d)
viz.callback(CLIENT_UPDATE,onUpdateGrabbers)